# FedFACT

This repository is built based on PyTorch, containing the code for FedFACT

## Installation

The code is tested on Python 3.12. The dependencies can be installed using the following command. (Before proceeding, it is recommended to create a new conda environment.)

```bash
pip install -r requirements.txt
```

## Dataset

- **Compas**
  
  - Download
  
  - https://raw.githubusercontent.com/propublica/compas-analysis/master/compas-scores-two-years.csv
  
  - Place it in the folder: data/compas/raw_data

- **Adult**
  
  - Download the following files:
  
  - https://archive.ics.uci.edu/ml/machine-learning-databases/adult/adult.data
    
    https://archive.ics.uci.edu/ml/machine-learning-databases/adult/adult.test
    
    https://archive.ics.uci.edu/ml/machine-learning-databases/adult/adult.names
  
  - Place it in the folder: data/adult/raw_data

- **ENEM**
  
  - Download from https://download.inep.gov.br/microdados/microdados_enem_2020.zip
  
  - unzip microdados_enem_2020.zip, place them in the folder: data/enem/raw_data

- **CelebA**
  
  - Download files from https://mmlab.ie.cuhk.edu.hk/projects/CelebA.html
    
    - img_align_celeba.7z
    
    - identity_CelebA.txt
    
    - list_attr_celeba.txt
  
  - unzip img_align_celeba.7z, place them in the folder: data/celeba/raw_data

## Running the Code

**Run main.py to train the model.**

Example: Run fedavg and FedFACT with Adult.

```
python main.py --algorithm fedavg --data adult --num_round 50 --local_lr 0.001

python main.py --algorithm fedfact --data adult --client 5 --fairness_metric DP --post_round 20
```

For additional details on the parameters, please refer to the annotations in options.py.
